// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     content/common/vr_service.mojom
//

package org.chromium.mojom.content;

public final class VrSensorState extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 72;
    private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(72, 0)};
    private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

    public double timestamp;
    public int frameIndex;
    public VrVector4 orientation;
    public VrVector3 position;
    public VrVector3 angularVelocity;
    public VrVector3 linearVelocity;
    public VrVector3 angularAcceleration;
    public VrVector3 linearAcceleration;

    private VrSensorState(int version) {
        super(STRUCT_SIZE, version);
    }

    public VrSensorState() {
        this(0);
    }

    public static VrSensorState deserialize(org.chromium.mojo.bindings.Message message) {
        return decode(new org.chromium.mojo.bindings.Decoder(message));
    }

    @SuppressWarnings("unchecked")
    public static VrSensorState decode(org.chromium.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
        VrSensorState result = new VrSensorState(mainDataHeader.elementsOrVersion);
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.timestamp = decoder0.readDouble(8);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.frameIndex = decoder0.readInt(16);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, true);
            result.orientation = VrVector4.decode(decoder1);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(32, true);
            result.position = VrVector3.decode(decoder1);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(40, true);
            result.angularVelocity = VrVector3.decode(decoder1);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(48, true);
            result.linearVelocity = VrVector3.decode(decoder1);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(56, true);
            result.angularAcceleration = VrVector3.decode(decoder1);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(64, true);
            result.linearAcceleration = VrVector3.decode(decoder1);
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        encoder0.encode(timestamp, 8);
        encoder0.encode(frameIndex, 16);
        encoder0.encode(orientation, 24, true);
        encoder0.encode(position, 32, true);
        encoder0.encode(angularVelocity, 40, true);
        encoder0.encode(linearVelocity, 48, true);
        encoder0.encode(angularAcceleration, 56, true);
        encoder0.encode(linearAcceleration, 64, true);
    }

    /**
     * @see Object#equals(Object)
     */
    @Override
    public boolean equals(Object object) {
        if (object == this)
            return true;
        if (object == null)
            return false;
        if (getClass() != object.getClass())
            return false;
        VrSensorState other = (VrSensorState) object;
        if (this.timestamp != other.timestamp)
            return false;
        if (this.frameIndex != other.frameIndex)
            return false;
        if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.orientation, other.orientation))
            return false;
        if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.position, other.position))
            return false;
        if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.angularVelocity, other.angularVelocity))
            return false;
        if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.linearVelocity, other.linearVelocity))
            return false;
        if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.angularAcceleration, other.angularAcceleration))
            return false;
        if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.linearAcceleration, other.linearAcceleration))
            return false;
        return true;
    }

    /**
     * @see Object#hashCode()
     */
    @Override
    public int hashCode() {
        final int prime = 31;
        int result = prime + getClass().hashCode();
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(timestamp);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(frameIndex);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(orientation);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(position);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(angularVelocity);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(linearVelocity);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(angularAcceleration);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(linearAcceleration);
        return result;
    }
}

